/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.utils;

import com.aptana.editor.php.indexer.EntryUtils;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TypeUtils {
    public static List<IElementEntry> getFields(IElementEntry typeEntry) {
        return TypeUtils.getFields(typeEntry, PHPGlobalIndexer.getInstance().getIndex());
    }

    public static List<IElementEntry> getFields(IElementEntry typeEntry, IElementsIndex index) {
        if (typeEntry.getCategory() != 1) {
            throw new IllegalArgumentException("Only class entries are accepted");
        }
        IModule module = typeEntry.getModule();
        List<IElementEntry> entries = index.getEntriesStartingWith(3, typeEntry.getEntryPath());
        Iterator<IElementEntry> it = entries.iterator();
        while (it.hasNext()) {
            IElementEntry currentEntry = it.next();
            if (!currentEntry.getModule().equals(module)) {
                it.remove();
                continue;
            }
            if (currentEntry.getValue() instanceof VariablePHPEntryValue && ((VariablePHPEntryValue)currentEntry.getValue()).isField()) continue;
            it.remove();
        }
        return entries;
    }

    public static List<IElementEntry> getMethods(IElementEntry typeEntry) {
        return TypeUtils.getMethods(typeEntry, PHPGlobalIndexer.getInstance().getIndex());
    }

    public static List<IElementEntry> getMethods(IElementEntry typeEntry, IElementsIndex index) {
        if (typeEntry.getCategory() != 1) {
            throw new IllegalArgumentException("Only class entries are accepted");
        }
        IModule module = typeEntry.getModule();
        List<IElementEntry> entries = index.getEntriesStartingWith(2, typeEntry.getEntryPath());
        Iterator<IElementEntry> it = entries.iterator();
        while (it.hasNext()) {
            IElementEntry currentEntry = it.next();
            if (!currentEntry.getModule().equals(module)) {
                it.remove();
                continue;
            }
            if (currentEntry.getValue() instanceof FunctionPHPEntryValue && ((FunctionPHPEntryValue)currentEntry.getValue()).isMethod()) continue;
            it.remove();
        }
        return entries;
    }

    public static IElementEntry getDeclaringType(IElementEntry member) {
        return TypeUtils.getDeclaringType(member, PHPGlobalIndexer.getInstance().getIndex());
    }

    public static IElementEntry getDeclaringType(IElementEntry member, IElementsIndex index) {
        if (!EntryUtils.isField(member) && !EntryUtils.isMethod(member)) {
            throw new IllegalArgumentException("Only fields and methods are accepted");
        }
        IModule module = member.getModule();
        String memberPathStr = member.getEntryPath();
        Path memberPath = new Path(memberPathStr);
        IPath classPath = memberPath.removeLastSegments(1);
        String classPathStr = classPath.toPortableString();
        List<IElementEntry> classEntries = index.getEntries(1, classPathStr);
        if (classEntries == null || classEntries.isEmpty()) {
            return null;
        }
        for (IElementEntry classEntry : classEntries) {
            if (!classEntry.getModule().equals(module)) continue;
            return classEntry;
        }
        return null;
    }

    private TypeUtils() {
    }
}

